/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.modules;

import fifthcolumn.n.NMod;
import fifthcolumn.n.copenheimer.models.Waypoint;
import fifthcolumn.n.events.GrieferUpdateEvent;
import fifthcolumn.n.events.PlayerSpawnPositionEvent;
import fifthcolumn.n.events.SpawnPlayerEvent;
import fifthcolumn.n.modules.NAddOn;
import fifthcolumn.n.utils.BlockPosUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.waypoints.Waypoint;
import meteordevelopment.meteorclient.systems.waypoints.Waypoints;
import meteordevelopment.meteorclient.utils.world.Dimension;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_642;

public class WaypointSync
extends Module {
    public WaypointSync() {
        super(NAddOn.FIFTH_COLUMN_CATEGORY, "Waypoint Sync", "Syncs your waypoints. Disabled on 2b2t.org.");
    }

    @EventHandler
    public void spawnPosition(PlayerSpawnPositionEvent event) {
        this.mc.execute(() -> {
            Waypoints waypoints = Waypoints.get();
            waypoints.add(new Waypoint.Builder().name("Spawn").pos(event.blockPos()).build());
            waypoints.save();
        });
    }

    @EventHandler
    private void onPlayerSeen(SpawnPlayerEvent event) {
        this.mc.field_1687.method_18456().stream().filter(player -> player.method_7334().getId().equals(event.uuid())).findFirst().ifPresent(player -> {
            String playerName;
            long count = NMod.getCopeService().griefers().stream().filter(griefer -> griefer.playerId.equals(event.uuid())).count();
            if (count > 0L) {
                return;
            }
            Waypoints waypoints = Waypoints.get();
            meteordevelopment.meteorclient.systems.waypoints.Waypoint existingWaypoint = waypoints.get(playerName = "Player " + player.method_5820());
            if (existingWaypoint != null) {
                return;
            }
            Waypoint.Builder waypointBuilder = new Waypoint.Builder();
            waypointBuilder.name(playerName);
            waypointBuilder.pos(event.blockPos());
            waypointBuilder.icon("5c");
            meteordevelopment.meteorclient.systems.waypoints.Waypoint waypoint = waypointBuilder.build();
            waypoints.add(waypoint);
            waypoints.save();
        });
    }

    @EventHandler
    public void griefersUpdated(GrieferUpdateEvent event) {
        if (!((WaypointSync)Modules.get().get(WaypointSync.class)).isActive()) {
            return;
        }
        class_642 currentServer = this.mc.method_1558();
        if (currentServer == null || this.mc.field_1724 == null) {
            return;
        }
        Map<String, Waypoint> remoteWaypoints = event.griefers.stream().filter(griefer -> !griefer.playerName.equalsIgnoreCase(this.mc.field_1724.method_5820())).filter(griefer -> griefer.serverAddress.equalsIgnoreCase(currentServer.field_3761)).flatMap(griefer -> griefer.waypoints.stream()).collect(Collectors.toMap(waypoint -> waypoint.name, waypoint -> waypoint, (waypoint, waypoint2) -> waypoint));
        this.mc.execute(() -> {
            Waypoints waypoints = Waypoints.get();
            boolean waypointUpdated = false;
            for (Map.Entry entry : remoteWaypoints.entrySet()) {
                String s = (String)entry.getKey();
                Waypoint remoteWaypoint = (Waypoint)entry.getValue();
                meteordevelopment.meteorclient.systems.waypoints.Waypoint existingWaypoint = waypoints.get(remoteWaypoint.name);
                if (existingWaypoint != null && ((String)existingWaypoint.name.get()).equals(remoteWaypoint.name)) continue;
                Waypoint.Builder waypointBuilder = new Waypoint.Builder();
                waypointBuilder.name(remoteWaypoint.name);
                waypointBuilder.pos(BlockPosUtils.from(remoteWaypoint.position));
                waypointBuilder.icon("5c");
                waypointBuilder = remoteWaypoint.position.dimension.equals("OVERWORLD") ? waypointBuilder.dimension(Dimension.Nether) : (remoteWaypoint.position.dimension.equals("END") ? waypointBuilder.dimension(Dimension.End) : waypointBuilder.dimension(Dimension.Overworld));
                meteordevelopment.meteorclient.systems.waypoints.Waypoint waypoint = waypointBuilder.build();
                waypoints.add(waypoint);
                waypointUpdated = true;
            }
            if (waypointUpdated) {
                waypoints.save();
            }
        });
    }

    static {
        try (InputStream inputStream = WaypointSync.class.getResourceAsStream("/assets/nc/5c.png");){
            Waypoints.get().icons.put("5c", new class_1043(class_1011.method_4309((InputStream)Objects.requireNonNull(inputStream))));
        }
        catch (IOException e) {
            throw new RuntimeException("did not load 5c icon");
        }
    }
}

