/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.modules;

import fifthcolumn.n.modules.NAddOn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import meteordevelopment.meteorclient.events.entity.player.InteractBlockEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.Pool;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockIterator;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_476;

public class ChestStealerAura
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<Double> range;
    private final Setting<List<class_1792>> items;
    private final Setting<Mode> mode;
    private final Setting<Boolean> render;
    private final Setting<SettingColor> lineColor;
    private final Setting<SettingColor> sideColor;
    private final Setting<ShapeMode> shapeMode;
    private final Pool<class_2338.class_2339> blockPosPool;
    private final List<class_2338.class_2339> blocksList;
    private final List<class_2338> openedChestList;
    private final Pool<RenderBlock> renderBlockPool;
    private final List<RenderBlock> renderBlocks;
    private class_2338 chestBlock;
    private int delay1;
    private int delay2;
    private int delay3;
    private boolean isChested;
    private String address;

    public ChestStealerAura() {
        super(NAddOn.FIFTH_COLUMN_CATEGORY, "ChestStealerAura", "steal2win");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.range = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("range to steal")).defaultValue(4.5).min(1.0).max(6.0).build());
        this.items = this.sgGeneral.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("items")).description("items to steal")).build());
        this.mode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).defaultValue((Object)Mode.Aura)).build());
        this.render = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("shows what chests have been stolen from")).defaultValue((Object)true)).build());
        this.lineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The color of the lines of the blocks being rendered.")).visible(() -> this.render.get())).defaultValue(new SettingColor(204, 0, 0, 255)).build());
        this.sideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The color of the sides of the blocks being rendered.")).visible(() -> this.render.get())).defaultValue(new SettingColor(204, 0, 0, 10)).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).visible(() -> this.render.get())).defaultValue((Object)ShapeMode.Both)).build());
        this.blockPosPool = new Pool(class_2338.class_2339::new);
        this.blocksList = new ArrayList<class_2338.class_2339>();
        this.openedChestList = new ArrayList<class_2338>();
        this.renderBlockPool = new Pool(RenderBlock::new);
        this.renderBlocks = new ArrayList<RenderBlock>();
        this.chestBlock = null;
        this.delay1 = 0;
        this.delay2 = 0;
        this.delay3 = 0;
        this.isChested = false;
        this.address = null;
    }

    public void onActivate() {
        super.onActivate();
        for (RenderBlock renderBlock : this.renderBlocks) {
            this.renderBlockPool.free((Object)renderBlock);
        }
        this.renderBlocks.clear();
    }

    public void onDeactivate() {
        super.onDeactivate();
        for (RenderBlock renderBlock : this.renderBlocks) {
            this.renderBlockPool.free((Object)renderBlock);
        }
        this.renderBlocks.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    private void onTickPre(TickEvent.Pre event) {
        class_1263 inv;
        if (this.mc.method_1558() != null && !this.mc.method_1558().field_3761.equals(this.address)) {
            this.address = this.mc.method_1558().field_3761;
            this.openedChestList.clear();
        }
        this.renderBlocks.forEach(RenderBlock::tick);
        this.renderBlocks.removeIf(renderBlock -> renderBlock.ticks <= 0);
        for (class_2338 c : this.openedChestList) {
            this.renderBlocks.add(((RenderBlock)this.renderBlockPool.get()).set(c, 1));
        }
        if (this.delay3 >= 1) {
            --this.delay3;
            return;
        }
        if (this.isChested) {
            if (!(this.mc.field_1755 instanceof class_476)) {
                this.isChested = false;
                this.mc.field_1724.method_3137();
                this.delay2 = 3;
                return;
            }
            class_1707 container = (class_1707)((class_476)this.mc.field_1755).method_17577();
            inv = container.method_7629();
            if (inv.method_5442() || !inv.method_18862(new HashSet((Collection)this.items.get()))) {
                this.isChested = false;
                this.openedChestList.add(this.chestBlock);
                class_2350 dir = this.getDirectionToOtherChestHalf(this.mc.field_1687.method_8320(this.chestBlock));
                if (dir != null) {
                    switch (dir) {
                        case field_11043: {
                            this.openedChestList.add(new class_2338(this.chestBlock.method_10263(), this.chestBlock.method_10264(), this.chestBlock.method_10260() - 1));
                            break;
                        }
                        case field_11035: {
                            this.openedChestList.add(new class_2338(this.chestBlock.method_10263(), this.chestBlock.method_10264(), this.chestBlock.method_10260() + 1));
                            break;
                        }
                        case field_11034: {
                            this.openedChestList.add(new class_2338(this.chestBlock.method_10263() + 1, this.chestBlock.method_10264(), this.chestBlock.method_10260()));
                            break;
                        }
                        case field_11039: {
                            this.openedChestList.add(new class_2338(this.chestBlock.method_10263() - 1, this.chestBlock.method_10264(), this.chestBlock.method_10260()));
                            break;
                        }
                    }
                }
                this.mc.field_1724.method_3137();
                this.delay2 = 5;
                return;
            }
        } else {
            if (this.delay2 >= 0) {
                --this.delay2;
                return;
            }
            if (this.mode.get() != Mode.Aura) {
                return;
            }
            double pX = this.mc.field_1724.method_23317();
            double pY = this.mc.field_1724.method_23318();
            double pZ = this.mc.field_1724.method_23321();
            double rangeSq = Math.pow((Double)this.range.get(), 2.0);
            BlockIterator.register((int)((int)Math.ceil((Double)this.range.get())), (int)((int)Math.ceil((Double)this.range.get())), (blockPos, blockState) -> {
                if (Utils.squaredDistance((double)pX, (double)pY, (double)pZ, (double)((double)blockPos.method_10263() + 0.5), (double)((double)blockPos.method_10264() + 0.5), (double)((double)blockPos.method_10260() + 0.5)) > rangeSq || this.mc.field_1687.method_8320(blockPos).method_26204() != class_2246.field_10034 && this.mc.field_1687.method_8320(blockPos).method_26204() != class_2246.field_16328 || this.openedChestList.contains(blockPos)) {
                    return;
                }
                this.blocksList.add(((class_2338.class_2339)this.blockPosPool.get()).method_10101((class_2382)blockPos));
            });
            BlockIterator.after(() -> {
                this.blocksList.sort(Comparator.comparingDouble(value -> Utils.squaredDistance((double)pX, (double)pY, (double)pZ, (double)((double)value.method_10263() + 0.5), (double)((double)value.method_10264() + 0.5), (double)((double)value.method_10260() + 0.5))));
                if (this.blocksList.isEmpty()) {
                    return;
                }
                int count = 0;
                for (class_2338.class_2339 block : this.blocksList) {
                    if (count >= 1) break;
                    if (this.delay1 < 3) {
                        ++this.delay1;
                        break;
                    }
                    this.delay1 = 0;
                    if (!this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, new class_3965(new class_243((double)block.method_10263() + 0.5, (double)block.method_10264() + 0.5, (double)block.method_10260() + 0.5), class_2350.field_11036, (class_2338)block, true)).method_23665()) continue;
                    ++count;
                    this.chestBlock = new class_2338(block.method_10263(), block.method_10264(), block.method_10260());
                    this.isChested = true;
                }
                for (class_2338.class_2339 blockPos : this.blocksList) {
                    this.blockPosPool.free((Object)blockPos);
                }
                this.blocksList.clear();
            });
            return;
        }
        int i = 0;
        while (i < inv.method_5439()) {
            if (((List)this.items.get()).contains(inv.method_5438(i).method_7909())) {
                InvUtils.quickSwap().slotId(i);
                this.delay3 = 2;
                return;
            }
            ++i;
        }
        return;
    }

    @EventHandler
    private void onInteractBlock(InteractBlockEvent event) {
        if (this.mode.get() != Mode.Manual) {
            return;
        }
        this.chestBlock = event.result.method_17777();
        this.isChested = true;
    }

    public WWidget getWidget(GuiTheme theme) {
        WButton butt = theme.button("Reset opened chests list");
        butt.action = this.openedChestList::clear;
        return butt;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (!((Boolean)this.render.get()).booleanValue()) {
            return;
        }
        this.renderBlocks.sort(Comparator.comparingInt(o -> -o.ticks));
        this.renderBlocks.forEach(renderBlock -> renderBlock.render(event, (Color)this.sideColor.get(), (Color)this.lineColor.get(), (ShapeMode)this.shapeMode.get()));
    }

    private class_2350 getDirectionToOtherChestHalf(class_2680 blockState) {
        class_2745 chestType;
        try {
            chestType = (class_2745)blockState.method_11654((class_2769)class_2281.field_10770);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return chestType == class_2745.field_12569 ? null : class_2281.method_9758((class_2680)blockState);
    }

    public static enum Mode {
        Aura,
        Manual;

    }

    public static class RenderBlock {
        public class_2338.class_2339 pos = new class_2338.class_2339();
        public int ticksMax;
        public int ticks;

        public RenderBlock set(class_2338 blockPos, int tick) {
            this.pos.method_10101((class_2382)blockPos);
            this.ticksMax = tick;
            this.ticks = tick;
            return this;
        }

        public void tick() {
            --this.ticks;
        }

        public void render(Render3DEvent event, Color sides, Color lines, ShapeMode shapeMode) {
            int preSideA = sides.a;
            int preLineA = lines.a;
            sides.a = (int)((double)sides.a * ((double)this.ticks / (double)this.ticksMax));
            lines.a = (int)((double)lines.a * ((double)this.ticks / (double)this.ticksMax));
            event.renderer.box((class_2338)this.pos, sides, lines, shapeMode, 0);
            sides.a = preSideA;
            lines.a = preLineA;
        }
    }
}

