/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.modules;

import fifthcolumn.n.events.ReceiveMsgEvent;
import fifthcolumn.n.modules.NAddOn;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.events.game.SendMessageEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.misc.BetterChat;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringEscapeUtils;

public class AutoTranslate
extends Module {
    private final SettingGroup sgGeneral;
    public static final List<Module> CONFLICTING_MODULES = List.of(AutoTranslate.getModule(BetterChat.class));
    public final Setting<Boolean> translateOut;
    public final Setting<Boolean> translateIn;
    public final Setting<Lang> serverLang;
    public final Setting<Lang> localLang;

    public AutoTranslate() {
        super(NAddOn.FIFTH_COLUMN_CATEGORY, "AutoTranslate", "Google translate for block game");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.translateOut = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Translate outgoing")).description("messages you send")).defaultValue((Object)false)).build());
        this.translateIn = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Translate incoming")).description("messages you receive")).defaultValue((Object)true)).build());
        this.serverLang = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Server Language")).description("Language the server speaks")).defaultValue((Object)Lang.RUSSIAN)).build());
        this.localLang = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Local Language")).description("Language you speak")).defaultValue((Object)Lang.ENGLISH)).build());
    }

    @EventHandler
    private void onMessageSend(SendMessageEvent event) {
        if (((Boolean)this.translateOut.get()).booleanValue()) {
            String translated = this.translate(event.message, ((Lang)((Object)this.localLang.get())).value, ((Lang)((Object)this.serverLang.get())).value);
            if (!translated.isEmpty()) {
                event.message = translated;
            }
            AutoTranslate.reengageModules(AutoTranslate.disengageConflictingModules());
        }
    }

    @EventHandler
    private void onMessageReceive(ReceiveMsgEvent event) {
        if (((Boolean)this.translateIn.get()).booleanValue()) {
            String message = event.getMessage().getString();
            Thread translate = new Thread(() -> {
                String translated = this.translate(message, ((Lang)((Object)((Object)this.serverLang.get()))).value, ((Lang)((Object)((Object)this.localLang.get()))).value);
                class_310.method_1551().execute(() -> {
                    if (!translated.isEmpty()) {
                        this.mc.field_1705.method_1743().method_1812(class_2561.method_30163((String)("[TRANSLATED] <" + event.getSender() + "> " + translated)));
                    }
                    AutoTranslate.reengageModules(AutoTranslate.disengageConflictingModules());
                });
            });
            translate.start();
        }
    }

    public void onActivate() {
        super.onActivate();
    }

    public void onDeactivate() {
        super.onDeactivate();
    }

    public String translate(String text, String from, String to) {
        String translated = this.parseHTML(this.getHTML(text, from, to));
        return text.equalsIgnoreCase(translated) ? "" : translated;
    }

    private String getHTML(String text, String langFrom, String langTo) {
        String string;
        URL url = this.createURL(text, langFrom, langTo);
        URLConnection con = this.setupConnection(url);
        InputStreamReader streamReader = new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(streamReader);
        try {
            String line;
            StringBuilder html = new StringBuilder();
            while ((line = br.readLine()) != null) {
                html.append(line).append("\n");
            }
            string = html.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        br.close();
        return string;
    }

    private String parseHTML(String html) {
        String regex = "class=\"result-container\">([^<]*)<\\/div>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(html);
        matcher.find();
        String match = matcher.group(1);
        if (match == null || match.isEmpty()) {
            return null;
        }
        return StringEscapeUtils.unescapeHtml4((String)match);
    }

    private URL createURL(String text, String langFrom, String langTo) {
        try {
            String encodedText = URLEncoder.encode(text.trim(), StandardCharsets.UTF_8);
            String urlString = String.format("https://translate.google.com/m?hl=en&sl=%s&tl=%s&ie=UTF-8&prev=_m&q=%s", langFrom, langTo, encodedText);
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private URLConnection setupConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        return connection;
    }

    private static List<Module> disengageConflictingModules() {
        List<Module> modules = CONFLICTING_MODULES.stream().filter(Module::isActive).collect(Collectors.toList());
        modules.forEach(Module::toggle);
        return modules;
    }

    private static void reengageModules(List<Module> modules) {
        modules.forEach(Module::toggle);
    }

    private static Module getModule(Class module) {
        return Modules.get().get(module);
    }

    public static enum Lang {
        AFRIKAANS("Afrikaans", "af"),
        ARABIC("Arabic", "ar"),
        CZECH("Czech", "cs"),
        CHINESE_SIMPLIFIED("Chinese (simplified)", "zh-CN"),
        CHINESE_TRADITIONAL("Chinese (traditional)", "zh-TW"),
        DANISH("Danish", "da"),
        DUTCH("Dutch", "nl"),
        ENGLISH("English", "en"),
        FINNISH("Finnish", "fi"),
        FRENCH("French", "fr"),
        GERMAN("German", "de"),
        GREEK("Greek", "el"),
        HINDI("Hindi", "hi"),
        ITALIAN("Italian", "it"),
        JAPANESE("Japanese", "ja"),
        KOREAN("Korean", "ko"),
        NORWEGIAN("Norwegian", "no"),
        POLISH("Polish", "pl"),
        PORTUGUESE("Portuguese", "pt"),
        RUSSIAN("Russian", "ru"),
        SPANISH("Spanish", "es"),
        SWAHILI("Swahili", "sw"),
        SWEDISH("Swedish", "sv"),
        TURKISH("Turkish", "tr");

        private final String name;
        public final String value;

        private Lang(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }
}

