/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.modules;

import com.google.common.net.InetAddresses;
import fifthcolumn.n.modules.NAddOn;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.mixin.AbstractSignEditScreenAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2693;
import net.minecraft.class_2818;
import net.minecraft.class_2877;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_642;
import net.minecraft.class_8242;
import org.apache.commons.lang3.StringUtils;

public class AutoSign
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<TextPreset> textPreset;
    private final Setting<String> signTextLine1;
    private final Setting<String> signTextLine2;
    private final Setting<String> signTextLine3;
    private final Setting<String> signTextLine4;
    private static final String ticketNumberReplace = "<ticketNumber>";
    private final Setting<Boolean> editSignAura;
    private final Setting<Double> distance;
    private final Setting<Integer> delay;
    private Instant lastEdit;
    private boolean interacting;
    private Instant interactTime;
    private Duration interactTimeout;

    public AutoSign() {
        super(NAddOn.FIFTH_COLUMN_CATEGORY, "AutoSign", "Places bait signs to the 5c discord");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.textPreset = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Text Preset")).description("What do sign say?")).defaultValue((Object)TextPreset.FifthColumn)).build());
        this.signTextLine1 = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Line 1")).description("The text to put on the sign line 1.")).defaultValue((Object)"Rekt by")).visible(() -> this.textPreset.get() == TextPreset.Custom)).build());
        this.signTextLine2 = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Line 2")).description("The text to put on the sign line 2.")).defaultValue((Object)"discord.gg/")).visible(() -> this.textPreset.get() == TextPreset.Custom)).build());
        this.signTextLine3 = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Line 3")).description("The text to put on the sign line 3.")).defaultValue((Object)"thefifthcolumn")).visible(() -> this.textPreset.get() == TextPreset.Custom)).build());
        this.signTextLine4 = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Line 4")).description("The text to put on the sign line 4.")).defaultValue((Object)"#<ticketNumber>")).visible(() -> this.textPreset.get() == TextPreset.Custom)).build());
        this.editSignAura = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Edit Sign Aura")).description("Automatically edits signs around you.")).defaultValue((Object)false)).build());
        this.distance = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("Distance")).description("The distance to search for signs.")).defaultValue(5.0).min(0.1).sliderMax(10.0).visible(() -> this.editSignAura.get())).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Delay")).description("The delay between editing signs.")).defaultValue((Object)100)).min(0).sliderMax(1000).visible(() -> this.editSignAura.get())).build());
        this.lastEdit = Instant.EPOCH;
        this.interacting = false;
        this.interactTime = Instant.EPOCH;
        this.interactTimeout = Duration.ofMillis(500L);
    }

    @EventHandler
    public void onOpenScreen(OpenScreenEvent event) {
        if (!this.isActive()) {
            return;
        }
        if (event.screen instanceof AbstractSignEditScreenAccessor) {
            event.cancel();
        }
    }

    private class_2877 getUpdateSignPacket(class_2338 pos, boolean front) {
        return switch ((TextPreset)((Object)this.textPreset.get())) {
            case TextPreset.FifthColumn -> new class_2877(pos, front, "Rekt by", "discord.gg/", "thefifthcolumn", "#" + this.getTicketNumber());
            case TextPreset.Astral -> new class_2877(pos, front, "Rekt by Astral", "discord.gg/", "e58M9R5TDA", "#<" + this.getTicketNumber() + ">");
            case TextPreset.ServerSeeker -> new class_2877(pos, front, "Rekt by", "ServerSeeker", "serverseeker.net", "msg DAM");
            default -> new class_2877(pos, front, this.replaceText((String)this.signTextLine1.get()), this.replaceText((String)this.signTextLine2.get()), this.replaceText((String)this.signTextLine3.get()), this.replaceText((String)this.signTextLine4.get()));
        };
    }

    private String replaceText(String text) {
        return StringUtils.replace((String)text, (String)ticketNumberReplace, (String)this.getTicketNumber());
    }

    @EventHandler
    public void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.mc.field_1687 == null) {
            return;
        }
        if (!((Boolean)this.editSignAura.get()).booleanValue()) {
            return;
        }
        if (Instant.now().isBefore(this.lastEdit.plusMillis(((Integer)this.delay.get()).intValue()))) {
            return;
        }
        this.lastEdit = Instant.now();
        if (this.interacting && Instant.now().isBefore(this.interactTime.plus(this.interactTimeout))) {
            return;
        }
        class_1923 playerChunkPos = this.mc.field_1724.method_31476();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2818 chunk = this.mc.field_1687.method_8497(playerChunkPos.field_9181 + x, playerChunkPos.field_9180 + z);
                Map blockEntities = chunk.method_12214();
                for (Map.Entry entry : blockEntities.entrySet()) {
                    class_2625 signBlockEntity;
                    class_2338 blockPos = (class_2338)entry.getKey();
                    class_2586 blockEntity = (class_2586)entry.getValue();
                    if (!(blockEntity instanceof class_2625) || (signBlockEntity = (class_2625)blockEntity).method_49855() || !blockPos.method_19769((class_2374)this.mc.field_1724.method_33571(), ((Double)this.distance.get()).doubleValue()) || !this.shouldUpdateText(signBlockEntity)) continue;
                    class_3959 raycastContext = new class_3959(new class_243(this.mc.field_1724.method_23317(), this.mc.field_1724.method_33571().field_1351, this.mc.field_1724.method_23321()), new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724);
                    class_3965 raycast = this.mc.field_1687.method_17742(raycastContext);
                    boolean playerFacingFront = signBlockEntity.method_49834((class_1657)this.mc.field_1724);
                    if (!this.isSignUnedited(signBlockEntity.method_49843(playerFacingFront))) continue;
                    this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, raycast);
                    this.interacting = false;
                    this.interactTime = Instant.now();
                    return;
                }
            }
        }
    }

    @EventHandler
    public void onPacketReceived(PacketEvent.Receive event) {
        if (event.packet instanceof class_2693) {
            this.mc.field_1724.field_3944.method_52787((class_2596)this.getUpdateSignPacket(((class_2693)event.packet).method_11677(), ((class_2693)event.packet).method_49995()));
            this.interacting = false;
            event.cancel();
        }
    }

    private boolean shouldUpdateText(class_2625 blockEntity) {
        return this.isSignUnedited(blockEntity.method_49843(true)) || this.isSignUnedited(blockEntity.method_49843(false));
    }

    private boolean isSignUnedited(class_8242 signText) {
        return !signText.method_49859(0, false).getString().equals(this.replaceText((String)this.signTextLine1.get())) || !signText.method_49859(1, false).getString().equals(this.replaceText((String)this.signTextLine2.get())) || !signText.method_49859(2, false).getString().equals(this.replaceText((String)this.signTextLine3.get())) || !signText.method_49859(3, false).getString().equals(this.replaceText((String)this.signTextLine4.get()));
    }

    private String getTicketNumber() {
        Inet4Address address;
        class_642 entry = this.mc.method_1558();
        if (entry == null || entry.field_3761 == null) {
            return this.textPreset.get() == TextPreset.Astral ? "Astral on top!" : "5C ON TOP";
        }
        String ip = entry.field_3761.split(":")[0];
        try {
            address = (Inet4Address)Inet4Address.getByName(ip);
        }
        catch (UnknownHostException e) {
            return StringUtils.abbreviate((String)this.mc.field_1724.method_5820(), (int)15);
        }
        return String.valueOf(InetAddresses.coerceToInteger((InetAddress)address));
    }

    public static enum TextPreset {
        FifthColumn,
        Astral,
        ServerSeeker,
        Custom;

    }
}

