/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.copenheimer.models;

import fifthcolumn.n.copenheimer.models.Griefer;
import fifthcolumn.n.modules.StreamerMode;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import meteordevelopment.meteorclient.systems.modules.Modules;

public final class Server {
    public String serverAddress;
    public String description;
    public String icon;
    public Set<Griefer> griefers;
    public Boolean cracked;

    public String displayServerAddress() {
        return Server.displayForServerAddress(this.serverAddress);
    }

    public static String displayForServerAddress(String serverAddress) {
        StreamerMode streamerMode = (StreamerMode)Modules.get().get(StreamerMode.class);
        if (streamerMode != null && streamerMode.isActive()) {
            try {
                int ipOffset = (Boolean)streamerMode.useRandomIpOffset.get() != false ? new Random().nextInt(1, 254) : 0;
                int ipHeader = (Integer.parseInt(serverAddress.substring(0, serverAddress.indexOf("."))) + ipOffset) % 255;
                return ipHeader + ".xxx.xxx.xxx";
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException ignored) {
                return "Server";
            }
        }
        return serverAddress;
    }

    public String displayDescription() {
        if (StreamerMode.isHideServerInfoEnabled()) {
            return "No peeking ;)";
        }
        if (this.description == null) {
            return "";
        }
        return this.description.replaceAll("[\ud83c\udf00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]", "");
    }

    public Optional<String> iconData() {
        if (this.icon != null && this.icon.startsWith("data:image/png;base64,")) {
            return Optional.of(this.icon.substring("data:image/png;base64,".length()));
        }
        return Optional.empty();
    }
}

