/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.copenheimer;

import fifthcolumn.n.copenheimer.CopeService;
import fifthcolumn.n.copenheimer.http.FindServersRequest;
import fifthcolumn.n.copenheimer.http.FindServersResponse;
import fifthcolumn.n.copenheimer.http.FindStreamersRequest;
import fifthcolumn.n.copenheimer.http.FindStreamersResponse;
import fifthcolumn.n.copenheimer.models.Server;
import fifthcolumn.n.copenheimer.models.Streamer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_3577;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchService.class);
    private final CopeService copeService;
    private AtomicBoolean loading = new AtomicBoolean(false);
    public final FindServersRequest currentFindRequest = SearchService.defaultFindRequest();

    public SearchService(CopeService copeService) {
        this.copeService = copeService;
    }

    public boolean isLoading() {
        return this.loading.get();
    }

    public void findStreamers(Consumer<List<Streamer>> resultConsumer) {
        this.loading.set(true);
        this.copeService.executor.execute(() -> {
            try {
                String content = this.copeService.post("http://cope.fifthcolumnmc.com/api/streamers/active", new FindStreamersRequest());
                FindStreamersResponse response = (FindStreamersResponse)class_3577.field_15827.fromJson(content, FindStreamersResponse.class);
                this.loading.set(false);
                resultConsumer.accept(response.streamers());
            }
            catch (Throwable e) {
                LOGGER.error("CopeService Find Error", e);
                this.loading.set(false);
            }
        });
    }

    public void find(BiConsumer<List<Server>, List<Server>> resultConsumer) {
        this.currentFindRequest.skip = 0;
        this.doFind(resultConsumer);
    }

    public void findMore(BiConsumer<List<Server>, List<Server>> resultConsumer) {
        FindServersRequest findServersRequest = this.currentFindRequest;
        findServersRequest.skip = findServersRequest.skip + this.currentFindRequest.limit;
        this.doFind(resultConsumer);
    }

    private void doFind(BiConsumer<List<Server>, List<Server>> resultConsumer) {
        this.loading.set(true);
        this.copeService.executor.execute(() -> {
            try {
                String content = this.copeService.post("http://cope.fifthcolumnmc.com/api/servers/find", this.currentFindRequest);
                FindServersResponse servers = (FindServersResponse)class_3577.field_15827.fromJson(content, FindServersResponse.class);
                this.loading.set(false);
                resultConsumer.accept(servers.searchResult, servers.activeServers);
            }
            catch (Throwable e) {
                LOGGER.error("CopeService Find Error", e);
                this.loading.set(false);
            }
        });
    }

    private static FindServersRequest defaultFindRequest() {
        FindServersRequest request = new FindServersRequest();
        request.hasName = null;
        request.hasVersion = class_155.method_16673().method_48019();
        request.playersOnline = true;
        request.isModded = false;
        request.isProtected = false;
        request.isWhitelisted = false;
        request.isGriefed = false;
        request.isCracked = false;
        request.skip = 0;
        request.limit = 1000;
        request.lang = null;
        request.multiProtocol = false;
        request.orderBy = FindServersRequest.OrderBy.ONLINE_PLAYERS;
        return request;
    }
}

