/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.copenheimer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fifthcolumn.n.client.ui.copenheimer.servers.CopeServerInfo;
import fifthcolumn.n.collar.CollarLogin;
import fifthcolumn.n.copenheimer.SearchService;
import fifthcolumn.n.copenheimer.http.ActiveServerRequest;
import fifthcolumn.n.copenheimer.http.ActiveServerResponse;
import fifthcolumn.n.copenheimer.http.FindPlayersRequest;
import fifthcolumn.n.copenheimer.http.GetAccountResponse;
import fifthcolumn.n.copenheimer.http.TranslateRequest;
import fifthcolumn.n.copenheimer.http.TranslateResponse;
import fifthcolumn.n.copenheimer.http.UpdateServerRequest;
import fifthcolumn.n.copenheimer.models.Griefer;
import fifthcolumn.n.copenheimer.models.Position;
import fifthcolumn.n.copenheimer.models.Server;
import fifthcolumn.n.copenheimer.models.ServerPlayer;
import fifthcolumn.n.copenheimer.models.Waypoint;
import fifthcolumn.n.events.GrieferUpdateEvent;
import fifthcolumn.n.modules.GrieferTracer;
import fifthcolumn.n.modules.LarpModule;
import fifthcolumn.n.modules.TwoBeeTwoTee;
import fifthcolumn.n.modules.WaypointSync;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.waypoints.Waypoints;
import meteordevelopment.meteorclient.utils.world.Dimension;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopeService.class);
    static final String BASE_URL = "http://cope.fifthcolumnmc.com/";
    private static final Long backgroundRefreshIntervalMs = 50L;
    private static final Gson GSON = new Gson();
    private final HttpClient clientDelegate = HttpClient.newBuilder().build();
    public final Executor executor = Executors.newFixedThreadPool(3, r -> {
        Thread thread = new Thread(r);
        thread.setName("CopeService");
        return thread;
    });
    public final ScheduledExecutorService backgroundActiveExecutorService = new ScheduledThreadPoolExecutor(1);
    public final SearchService search;
    private class_642 currentServer;
    private class_642 serverInfo;
    private class_320 defaultSession;
    private ScheduledFuture<?> backgroundActiveRefresh;
    private final ConcurrentHashMap<String, Griefer> griefers = new ConcurrentHashMap();
    private final LoadingCache<TranslateRequest, CompletableFuture<Optional<TranslateResponse>>> translationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<TranslateRequest, CompletableFuture<Optional<TranslateResponse>>>(){

        public CompletableFuture<Optional<TranslateResponse>> load(TranslateRequest req) throws Exception {
            CompletableFuture<Optional<TranslateResponse>> resp = new CompletableFuture<Optional<TranslateResponse>>();
            CopeService.this.executor.execute(() -> {
                try {
                    String content = CopeService.this.post("http://cope.fifthcolumnmc.com/api/text/translate", req);
                    Optional<TranslateResponse> translateResponse = Optional.ofNullable((TranslateResponse)GSON.fromJson(content, TranslateResponse.class));
                    resp.complete(translateResponse);
                }
                catch (Throwable e) {
                    LOGGER.error("CopeService Translate Error", e);
                    resp.complete(Optional.empty());
                }
            });
            return resp;
        }
    });
    private String lastOpenedStreamUrl = null;

    public CopeService() {
        this.search = new SearchService(this);
    }

    public List<Griefer> griefers() {
        return new ArrayList<Griefer>(this.griefers.values());
    }

    public List<Griefer> griefersOnServer() {
        if (MeteorClient.mc.field_1724 == null) {
            return this.griefers();
        }
        return this.griefers().stream().filter(griefer -> griefer.playerId != null && !griefer.playerId.equals(MeteorClient.mc.field_1724.method_5667())).filter(griefer -> MeteorClient.mc.method_1558() != null && griefer.serverAddress.equals(MeteorClient.mc.method_1558().field_3761)).collect(Collectors.toList());
    }

    public void openStreamUrl() {
        class_642 class_6422 = MeteorClient.mc.method_1558();
        if (class_6422 instanceof CopeServerInfo) {
            String streamUrl;
            CopeServerInfo serverInfo = (CopeServerInfo)class_6422;
            if (serverInfo.streamer != null && !(streamUrl = serverInfo.streamer.stream().streamUrl()).equals(this.lastOpenedStreamUrl)) {
                this.lastOpenedStreamUrl = streamUrl;
                class_156.method_668().method_670(streamUrl);
            }
        }
    }

    public void update(UpdateServerRequest req, Consumer<Server> serverConsumer) {
        this.executor.execute(() -> {
            try {
                String content = this.post("http://cope.fifthcolumnmc.com/api/servers/update", req);
                serverConsumer.accept((Server)GSON.fromJson(content, Server.class));
            }
            catch (Throwable e) {
                LOGGER.error("CopeService Update Error", e);
            }
        });
    }

    public void disconnected() {
        this.executor.execute(() -> {
            try {
                this.post("http://cope.fifthcolumnmc.com/api/servers/disconnected", null);
            }
            catch (Throwable e) {
                LOGGER.error("CopeService Update Error", e);
            }
        });
    }

    public void findHistoricalPlayers(Consumer<List<ServerPlayer>> playersConsumer) {
        this.createFindPlayersRequest().ifPresent(req -> this.executor.execute(() -> this.findHistoricalPlayers((FindPlayersRequest)req).ifPresent(playersConsumer)));
    }

    public Optional<List<ServerPlayer>> findHistoricalPlayers(FindPlayersRequest request) {
        try {
            String content = this.post("http://cope.fifthcolumnmc.com/api/servers/findPlayers", request);
            return Optional.of((List)GSON.fromJson(content, new TypeToken<ArrayList<ServerPlayer>>(){}.getType()));
        }
        catch (Throwable e) {
            LOGGER.error("CopeService FindPlayers Error", e);
            return Optional.empty();
        }
    }

    public CompletableFuture<Optional<TranslateResponse>> translate(TranslateRequest request) {
        return (CompletableFuture)this.translationCache.getUnchecked((Object)request);
    }

    public void getAccount(Consumer<GetAccountResponse> consumer) {
        this.executor.execute(() -> {
            String response = this.httpGet("http://cope.fifthcolumnmc.com/api/accounts/alt");
            consumer.accept((GetAccountResponse)GSON.fromJson(response, GetAccountResponse.class));
        });
    }

    private void setActive(ActiveServerRequest req) {
        try {
            String body = this.post("http://cope.fifthcolumnmc.com/api/servers/active", req);
            ActiveServerResponse resp = (ActiveServerResponse)GSON.fromJson(body, ActiveServerResponse.class);
            resp.griefers.forEach(griefer -> this.griefers.put(griefer.profileName, (Griefer)griefer));
            MeteorClient.EVENT_BUS.post((Object)new GrieferUpdateEvent(resp.griefers));
        }
        catch (Throwable e) {
            LOGGER.error("CopeService Active Server Error", e);
        }
    }

    String post(String url, @Nullable Object req) {
        String body = GSON.toJson(req);
        HttpRequest.BodyPublisher publisher = body != null ? HttpRequest.BodyPublishers.ofString(body) : HttpRequest.BodyPublishers.noBody();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(20L)).header("x-collar-membership", CollarLogin.getMembershipToken()).headers("x-player-name", MeteorClient.mc.method_1548().method_1676()).POST(publisher).build();
        return this.execute(request);
    }

    private String httpGet(String url) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(20L)).header("x-collar-membership", CollarLogin.getMembershipToken()).headers("x-player-name", MeteorClient.mc.method_1548().method_1676()).GET().build();
        return this.execute(request);
    }

    private String execute(HttpRequest request) {
        HttpResponse<String> response;
        try {
            response = this.clientDelegate.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
        int code = response.statusCode();
        if (code != 200) {
            throw new RuntimeException("status: " + code + " body: " + response.body());
        }
        return response.body();
    }

    public void backgroundActiveServerUpdate() {
        if (MeteorClient.mc == null) {
            return;
        }
        class_642 serverEntry = MeteorClient.mc.method_1558();
        if (serverEntry == null) {
            return;
        }
        class_746 player = MeteorClient.mc.field_1724;
        if (player == null) {
            return;
        }
        Position location = null;
        Modules modules = Modules.get();
        if (modules.isActive(GrieferTracer.class) && TwoBeeTwoTee.isLocationSharingOn()) {
            location = Position.from((class_1657)player);
        }
        List<Waypoint> waypoints = Collections.emptyList();
        if (modules.isActive(WaypointSync.class) && TwoBeeTwoTee.isLocationSharingOn()) {
            waypoints = Waypoints.get().waypoints.values().stream().map(waypoint -> {
                Waypoint newWaypoint = new Waypoint();
                newWaypoint.name = (String)waypoint.name.get();
                newWaypoint.position = new Position();
                newWaypoint.position.x = waypoint.getPos().method_10263();
                newWaypoint.position.y = waypoint.getPos().method_10264();
                newWaypoint.position.z = waypoint.getPos().method_10260();
                if (waypoint.dimension.get() == Dimension.Overworld) {
                    newWaypoint.position.dimension = "OVERWORLD";
                } else if (waypoint.dimension.get() == Dimension.End) {
                    newWaypoint.position.dimension = "END";
                } else if (waypoint.dimension.get() == Dimension.Nether) {
                    newWaypoint.position.dimension = "NETHER";
                }
                return newWaypoint;
            }).collect(Collectors.toList());
        }
        String playerNameAlias = modules.isActive(LarpModule.class) ? (String)((LarpModule)modules.get(LarpModule.class)).aliasName.get() : null;
        try {
            this.setActive(new ActiveServerRequest(serverEntry.field_3761, player.method_5820(), MeteorClient.mc.field_1724.method_5667(), playerNameAlias, location, waypoints));
        }
        catch (Exception e) {
            LOGGER.error("Active server request failed.", (Throwable)e);
        }
    }

    public synchronized void startUpdating() {
        if (this.backgroundActiveRefresh == null) {
            this.backgroundActiveRefresh = this.backgroundActiveExecutorService.scheduleAtFixedRate(this::backgroundActiveServerUpdate, 0L, backgroundRefreshIntervalMs, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopUpdating() {
        if (this.backgroundActiveRefresh == null) {
            return;
        }
        this.backgroundActiveRefresh.cancel(true);
        this.backgroundActiveRefresh = null;
    }

    public Optional<FindPlayersRequest> createFindPlayersRequest() {
        class_642 currentServerEntry = MeteorClient.mc.method_1558();
        if (currentServerEntry == null) {
            return Optional.empty();
        }
        if (currentServerEntry.equals(this.currentServer)) {
            return Optional.empty();
        }
        this.currentServer = currentServerEntry;
        return Optional.of(this.createFindPlayersRequest(currentServerEntry.field_3761));
    }

    public FindPlayersRequest createFindPlayersRequest(String server) {
        FindPlayersRequest request = new FindPlayersRequest();
        request.serverAddress = server;
        return request;
    }

    public void clearTranslations() {
        this.translationCache.invalidateAll();
    }

    public void setLastServerInfo(class_642 currentServerEntry) {
        this.serverInfo = currentServerEntry;
    }

    public class_642 getLastServerInfo() {
        return this.serverInfo;
    }

    public void setDefaultSession(class_320 session) {
        this.defaultSession = session;
    }

    public void setDefaultSession() {
        if (this.defaultSession == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        ((MinecraftClientAccessor)mc).setSession(this.defaultSession);
    }

    public class_320 getDefaultSession() {
        return this.defaultSession;
    }
}

