/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.client.ui.copenheimer.servers;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import fifthcolumn.n.NMod;
import fifthcolumn.n.client.ui.copenheimer.servers.CopeMultiplayerScreen;
import fifthcolumn.n.client.ui.copenheimer.servers.CopeServerInfo;
import fifthcolumn.n.client.ui.copenheimer.servers.ServerList;
import fifthcolumn.n.copenheimer.models.LiveStream;
import fifthcolumn.n.modules.StreamerMode;
import java.lang.invoke.LambdaMetafactory;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import meteordevelopment.meteorclient.MeteorClient;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import net.minecraft.class_8573;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CopeServerListWidget
extends class_4280<Entry> {
    static final class_2960 INCOMPATIBLE_TEXTURE = new class_2960("server_list/incompatible");
    static final class_2960 UNREACHABLE_TEXTURE = new class_2960("server_list/unreachable");
    static final class_2960 PING_1_TEXTURE = new class_2960("server_list/ping_1");
    static final class_2960 PING_2_TEXTURE = new class_2960("server_list/ping_2");
    static final class_2960 PING_3_TEXTURE = new class_2960("server_list/ping_3");
    static final class_2960 PING_4_TEXTURE = new class_2960("server_list/ping_4");
    static final class_2960 PING_5_TEXTURE = new class_2960("server_list/ping_5");
    static final class_2960 PINGING_1_TEXTURE = new class_2960("server_list/pinging_1");
    static final class_2960 PINGING_2_TEXTURE = new class_2960("server_list/pinging_2");
    static final class_2960 PINGING_3_TEXTURE = new class_2960("server_list/pinging_3");
    static final class_2960 PINGING_4_TEXTURE = new class_2960("server_list/pinging_4");
    static final class_2960 PINGING_5_TEXTURE = new class_2960("server_list/pinging_5");
    static final class_2960 EGG_TEXTURE = new class_2960("nc:egg.png");
    static final class_2960 JOIN_HIGHLIGHTED_TEXTURE = new class_2960("server_list/join_highlighted");
    static final class_2960 JOIN_TEXTURE = new class_2960("server_list/join");
    private static final class_2960 SCROLLER_TEXTURE = new class_2960("widget/scroller");
    static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor SERVER_PINGER_THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER)).build());
    private static final class_2960 UNKNOWN_SERVER_TEXTURE = new class_2960("textures/misc/unknown_server.png");
    static final class_2561 LAN_SCANNING_TEXT = class_2561.method_43471((String)"lanServer.scanning");
    static final class_2561 CANNOT_RESOLVE_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_resolve").method_27694(style -> style.method_36139(-65536));
    static final class_2561 CANNOT_CONNECT_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_connect").method_27694(style -> style.method_36139(-65536));
    static final class_2561 INCOMPATIBLE_TEXT = class_2561.method_43471((String)"multiplayer.status.incompatible");
    static final class_2561 NO_CONNECTION_TEXT = class_2561.method_43471((String)"multiplayer.status.no_connection");
    static final class_2561 PINGING_TEXT = class_2561.method_43471((String)"multiplayer.status.pinging");
    static final class_2561 ONLINE_TEXT = class_2561.method_43471((String)"multiplayer.status.online");
    private final CopeMultiplayerScreen screen;
    private final List<ServerEntry> servers = Lists.newArrayList();
    private boolean renderHeader = false;

    public CopeServerListWidget(CopeMultiplayerScreen screen, class_310 client, int width, int height, int y, int entryHeight) {
        super(client, width, height, y, entryHeight);
        this.screen = screen;
    }

    public List<ServerEntry> getServers() {
        return this.servers;
    }

    private void updateEntries() {
        this.method_25339();
        this.servers.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
    }

    public void setSelected(@Nullable Entry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.updateButtonActivationStates();
    }

    public Optional<Entry> removeSelectedServerEntry() {
        Optional<Entry> entry = Optional.ofNullable((Entry)this.method_25334());
        entry.ifPresent(e -> {
            this.servers.remove(e);
            this.method_25314(Collections.unmodifiableList(this.servers));
        });
        return entry;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Entry entry = (Entry)this.method_25334();
        return entry != null && entry.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public void setServers(ServerList servers) {
        this.servers.clear();
        for (int i = 0; i < servers.size(); ++i) {
            this.servers.add(new ServerEntry(this.screen, servers.get(i)));
        }
        this.updateEntries();
    }

    protected int method_25329() {
        return super.method_25329() + 30;
    }

    public int method_25322() {
        return super.method_25322() + 85;
    }

    public void onRemoved() {
    }

    protected void method_25315(boolean renderHeader, int headerHeight) {
        super.method_25315(renderHeader, headerHeight);
        this.renderHeader = true;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int j;
        this.method_49603(context);
        if (this.renderHeader) {
            int rowLeft = this.method_25342();
            j = this.method_46427() + 4 - (int)this.method_25341();
            this.method_25312(context, rowLeft, j);
        }
        this.method_25311(context, mouseX, mouseY, delta);
        context.method_44380();
        int maxScroll = this.method_25331();
        if (maxScroll > 0) {
            j = this.method_25329();
            int k = (int)((float)(this.field_22759 * this.field_22759) / (float)this.method_25317());
            k = class_3532.method_15340((int)k, (int)32, (int)(this.field_22759 - 8));
            int l = (int)this.method_25341() * (this.field_22759 - k) / maxScroll + this.method_46427();
            if (l < this.method_46427()) {
                l = this.method_46427();
            }
            context.method_25294(j, this.method_46427(), j + 6, this.method_46427() + this.field_22759, -16777216);
            context.method_52706(SCROLLER_TEXTURE, j, l, 6, k);
        }
        this.method_25320(context, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ServerEntry
    extends Entry {
        private static final class_2960 LOGO = new class_2960("nc:icon.png");
        public static final class_2960 TWITCH_LOGO = new class_2960("nc:twitch.png");
        public static final class_2960 KICK_LOGO = new class_2960("nc:kick.png");
        private static final int field_32387 = 32;
        private static final int field_32388 = 32;
        private static final int field_32390 = 32;
        private final CopeMultiplayerScreen screen;
        private final class_310 client;
        private final class_642 server;
        private final class_8573 icon;
        @Nullable
        private byte[] favicon;
        private long time;

        protected ServerEntry(CopeMultiplayerScreen screen, class_642 server) {
            this.screen = screen;
            this.server = server;
            this.client = class_310.method_1551();
            this.icon = class_8573.method_52202((class_1060)this.client.method_1531(), (String)server.field_3761);
        }

        private String getServerName(List<String> griefers) {
            return griefers.isEmpty() ? this.server.field_3752 : this.server.field_3752 + " with " + String.join((CharSequence)",", griefers);
        }

        @NotNull
        private List<String> getGriefers() {
            return NMod.getCopeService().griefers().stream().filter(griefer -> griefer.serverAddress.equals(this.server.field_3761)).map(griefer -> griefer.profileName).toList();
        }

        /*
         * Unable to fully structure code
         */
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            block30: {
                block29: {
                    if (!this.server.field_3754) {
                        this.server.field_3754 = true;
                        this.server.field_3758 = -2L;
                        this.server.field_3757 = class_5244.field_39003;
                        this.server.field_3753 = class_5244.field_39003;
                        CopeServerListWidget.SERVER_PINGER_THREAD_POOL.submit((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$render$3(), ()V)((ServerEntry)this));
                    }
                    griefers = this.getGriefers();
                    bl = this.protocolVersionMatches() == false;
                    context.method_51433(this.client.field_1772, this.getServerName(griefers), x + 32 + 3, y + 1, 0xFFFFFF, false);
                    labelText = StreamerMode.isHideServerInfoEnabled() != false ? class_2561.method_30163((String)"No peeking ;)") : (class_2561)MoreObjects.firstNonNull((Object)this.server.field_3757, (Object)class_2561.method_43473());
                    list = MeteorClient.mc.field_1772.method_1728((class_5348)labelText, entryWidth - 32 - 2);
                    for (i = 0; i < Math.min(list.size(), 2); ++i) {
                        var10001 = this.client.field_1772;
                        var10002 = (class_5481)list.get(i);
                        var10003 = x + 32 + 3;
                        var10004 = y + 12;
                        Objects.requireNonNull(this.client.field_1772);
                        context.method_51430(var10001, var10002, var10003, var10004 + 9 * i, -8355712, false);
                    }
                    text = bl != false ? this.server.field_3760.method_27661().method_27692(class_124.field_1061) : this.server.field_3753;
                    j = this.client.field_1772.method_27525((class_5348)text);
                    context.method_51439(this.client.field_1772, text, x + entryWidth - j - 32 - 2, y + 1, -8355712, false);
                    if (bl) {
                        identifier = CopeServerListWidget.INCOMPATIBLE_TEXTURE;
                        text2 = CopeServerListWidget.INCOMPATIBLE_TEXT;
                        list2 = this.server.field_3762;
                    } else if (this.pinged()) {
                        identifier = this.server.field_3758 < 0L ? CopeServerListWidget.UNREACHABLE_TEXTURE : (this.server.field_3758 < 150L ? CopeServerListWidget.PING_5_TEXTURE : (this.server.field_3758 < 300L ? CopeServerListWidget.PING_4_TEXTURE : (this.server.field_3758 < 600L ? CopeServerListWidget.PING_3_TEXTURE : (this.server.field_3758 < 1000L ? CopeServerListWidget.PING_2_TEXTURE : CopeServerListWidget.PING_1_TEXTURE))));
                        if (this.server.field_3758 < 0L) {
                            text2 = CopeServerListWidget.NO_CONNECTION_TEXT;
                            list2 = Collections.emptyList();
                        } else {
                            text2 = class_2561.method_43469((String)"multiplayer.status.ping", (Object[])new Object[]{this.server.field_3758});
                            list2 = this.server.field_3762;
                        }
                    } else {
                        k = (int)(class_156.method_658() / 100L + (long)(index * 2) & 7L);
                        if (k > 4) {
                            k = 8 - k;
                        }
                        switch (k) {
                            case 1: {
                                var10000 = CopeServerListWidget.PINGING_2_TEXTURE;
                                break;
                            }
                            case 2: {
                                var10000 = CopeServerListWidget.PINGING_3_TEXTURE;
                                break;
                            }
                            case 3: {
                                var10000 = CopeServerListWidget.PINGING_4_TEXTURE;
                                break;
                            }
                            case 4: {
                                var10000 = CopeServerListWidget.PINGING_5_TEXTURE;
                                break;
                            }
                            default: {
                                var10000 = CopeServerListWidget.PINGING_1_TEXTURE;
                            }
                        }
                        identifier = var10000;
                        text2 = CopeServerListWidget.PINGING_TEXT;
                        list2 = Collections.emptyList();
                    }
                    context.method_52706(identifier, x + entryWidth - 30, y, 10, 8);
                    var10000 = this.server;
                    if (var10000 instanceof CopeServerInfo) {
                        copeServerInfo = (CopeServerInfo)var10000;
                        if (copeServerInfo.server.cracked != null && copeServerInfo.server.cracked.booleanValue()) {
                            RenderSystem.enableBlend();
                            context.method_25290(CopeServerListWidget.EGG_TEXTURE, x + entryWidth - 17, y - 2, 0.0f, 0.0f, 12, 12, 12, 12);
                            RenderSystem.disableBlend();
                        }
                    }
                    if (!Arrays.equals(bs = this.server.method_49306(), this.favicon)) {
                        if (this.uploadFavicon(bs)) {
                            this.favicon = bs;
                        } else {
                            this.server.method_49305((byte[])null);
                        }
                    }
                    if (!griefers.isEmpty()) break block29;
                    var22_29 = this.server;
                    if (!(var22_29 instanceof CopeServerInfo)) ** GOTO lbl-1000
                    copeServerInfo = (CopeServerInfo)var22_29;
                    if (copeServerInfo.streamer != null) {
                        this.draw(context, x, y, copeServerInfo.streamer.stream().platform().equals((Object)LiveStream.Platform.KICK) != false ? ServerEntry.KICK_LOGO : ServerEntry.TWITCH_LOGO);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.draw(context, x, y, this.icon.method_52201());
                    }
                    break block30;
                }
                this.draw(context, x, y, ServerEntry.LOGO);
            }
            l = mouseX - x;
            m = mouseY - y;
            if (l >= entryWidth - 15 && l <= entryWidth - 5 && m >= 0 && m <= 8) {
                this.screen.setMultiplayerScreenTooltip(Collections.singletonList(text2));
            } else if (l >= entryWidth - j - 15 - 2 && l <= entryWidth - 15 - 2 && m >= 0 && m <= 8) {
                this.screen.setMultiplayerScreenTooltip(list2);
            }
            if (((Boolean)this.client.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                context.method_25294(x, y, x + 32, y + 32, -1601138544);
                n = mouseX - x;
                o = mouseY - y;
                if (this.canConnect()) {
                    if (n < 32 && n > 16) {
                        context.method_52706(CopeServerListWidget.JOIN_HIGHLIGHTED_TEXTURE, x, y, 32, 32);
                    } else {
                        context.method_52706(CopeServerListWidget.JOIN_TEXTURE, x, y, 32, 32);
                    }
                }
            }
        }

        private boolean pinged() {
            return this.server.field_3754 && this.server.field_3758 != -2L;
        }

        private boolean protocolVersionMatches() {
            return this.server.field_3756 == class_155.method_16673().method_48020();
        }

        protected void draw(class_332 context, int x, int y, class_2960 textureId) {
            RenderSystem.enableBlend();
            context.method_25290(textureId, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean canConnect() {
            return true;
        }

        private boolean uploadFavicon(@Nullable byte[] bytes) {
            if (bytes == null) {
                this.icon.method_52198();
            } else {
                try {
                    this.icon.method_52199(class_1011.method_49277((byte[])bytes));
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.server.field_3752, this.server.field_3761, var3});
                    return false;
                }
            }
            return true;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            CopeServerListWidget CopeServerListWidget2;
            int i;
            if (class_437.method_25442() && (i = (CopeServerListWidget2 = this.screen.serverListWidget).method_25396().indexOf(this)) == -1) {
                return true;
            }
            if (class_437.method_25438((int)keyCode)) {
                CopeServerInfo.copyToClipboard(this.server);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)CopeServerListWidget.this.method_25342();
            double e = mouseY - (double)CopeServerListWidget.this.method_25337(CopeServerListWidget.this.method_25396().indexOf(this));
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canConnect()) {
                this.screen.select(this);
                this.screen.connect();
                return true;
            }
            this.screen.select(this);
            if (class_156.method_658() - this.time < 250L) {
                this.screen.connect();
            }
            this.time = class_156.method_658();
            return true;
        }

        public class_642 getServer() {
            return this.server;
        }

        public class_2561 method_37006() {
            class_5250 mutableText = class_2561.method_43473();
            mutableText.method_10852((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.server.field_3752}));
            mutableText.method_10852(class_5244.field_33850);
            if (!this.protocolVersionMatches()) {
                mutableText.method_10852(INCOMPATIBLE_TEXT);
                mutableText.method_10852(class_5244.field_33850);
                mutableText.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.version.narration", (Object[])new Object[]{this.server.field_3760}));
                mutableText.method_10852(class_5244.field_33850);
                mutableText.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.field_3757}));
            } else if (this.server.field_3758 < 0L) {
                mutableText.method_10852(NO_CONNECTION_TEXT);
            } else if (!this.pinged()) {
                mutableText.method_10852(PINGING_TEXT);
            } else {
                mutableText.method_10852(ONLINE_TEXT);
                mutableText.method_10852(class_5244.field_33850);
                mutableText.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.ping.narration", (Object[])new Object[]{this.server.field_3758}));
                mutableText.method_10852(class_5244.field_33850);
                mutableText.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.field_3757}));
                if (this.server.field_41861 != null) {
                    mutableText.method_10852(class_5244.field_33850);
                    mutableText.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.player_count.narration", (Object[])new Object[]{this.server.field_41861.comp_1280(), this.server.field_41861.comp_1279()}));
                    mutableText.method_10852(class_5244.field_33850);
                    mutableText.method_10852(class_2564.method_37112((Collection)this.server.field_3762, (class_2561)class_2561.method_43470((String)", ")));
                }
            }
            return mutableText;
        }

        @Override
        public void close() {
            this.icon.close();
        }

        private /* synthetic */ void lambda$render$3() {
            try {
                this.screen.getServerListPinger().method_3003(this.server, () -> {});
            }
            catch (UnknownHostException var2) {
                this.server.field_3758 = -1L;
                this.server.field_3757 = CANNOT_RESOLVE_TEXT;
            }
            catch (Exception var3) {
                this.server.field_3758 = -1L;
                this.server.field_3757 = CANNOT_CONNECT_TEXT;
            }
        }
    }
}

