/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.client.ui.copenheimer.servers;

import fifthcolumn.n.client.ui.copenheimer.search.SearchParametersScreen;
import fifthcolumn.n.client.ui.copenheimer.servers.CopeServerInfo;
import fifthcolumn.n.client.ui.copenheimer.servers.CopeServerListWidget;
import fifthcolumn.n.client.ui.copenheimer.servers.ServerList;
import fifthcolumn.n.copenheimer.CopeService;
import fifthcolumn.n.copenheimer.http.UpdateServerRequest;
import fifthcolumn.n.copenheimer.models.Server;
import fifthcolumn.n.copenheimer.models.Streamer;
import fifthcolumn.n.modules.StreamerMode;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import meteordevelopment.meteorclient.gui.GuiThemes;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_644;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Nullable;

public class CopeMultiplayerScreen
extends class_437 {
    public static final class_2960 SERVER_BACKGROUND = new class_2960("nc:background.png");
    public static final class_2960 TWITCH_BACKGROUND = new class_2960("nc:twitch.png");
    private static final int BUTTON_WIDTH_TOP = 80;
    private static final int BUTTON_WIDTH_BOTTOM = 80;
    private static final int BUTTON_HEIGHT = 20;
    private final class_644 serverListPinger = new class_644();
    private final class_437 parent;
    private final CopeService copeService;
    protected CopeServerListWidget serverListWidget;
    private ServerList serverList;
    private class_4185 buttonModded;
    private class_4185 buttonJoin;
    private class_4185 protectedButton;
    private class_4185 whiteListedButton;
    private class_4185 griefedButton;
    @Nullable
    private List<class_2561> multiplayerScreenTooltip;
    private boolean initialized;
    private final Mode mode;

    public CopeMultiplayerScreen(class_437 parent, CopeService copeService, Mode mode) {
        super(class_2561.method_30163((String)("Copenheimer " + (mode == Mode.SERVERS ? "Servers" : "Streamers"))));
        this.parent = parent;
        this.copeService = copeService;
        this.mode = mode;
    }

    protected void method_25426() {
        if (!this.initialized) {
            this.initialized = true;
            this.serverList = new ServerList(this.serverListPinger);
            this.serverListWidget = new CopeServerListWidget(this, this.field_22787, this.field_22789, this.field_22790 - 64 - 32, 32, 36);
            this.serverListWidget.setServers(this.serverList);
            this.refreshList();
        }
        int buttonTopRowY = this.field_22790 - 52;
        int buttonBottomRowY = this.field_22790 - 28;
        int padding = 4;
        int farLeftXTopRow = this.field_22789 / 2 - 210;
        int farLeftXBottomRow = this.field_22789 / 2 - 210;
        this.method_25429((class_364)this.serverListWidget);
        this.buttonJoin = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.select"), button -> this.connect()).method_46434(farLeftXTopRow, buttonTopRowY, 80, 20).method_46431());
        if (this.mode == Mode.SERVERS) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Update search"), button -> this.field_22787.method_1507((class_437)new SearchParametersScreen((CopeMultiplayerScreen)this.field_22787.field_1755, this.copeService))).method_46434(farLeftXTopRow + 4 + 80, buttonTopRowY, 80, 20).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Hide Server"), button -> this.serverListWidget.removeSelectedServerEntry()).method_46434(farLeftXTopRow + 168, buttonTopRowY, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Show More"), button -> {
            if (!this.copeService.search.isLoading()) {
                this.showMore();
            }
        }).method_46434(farLeftXTopRow + 252, buttonTopRowY, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Refresh"), button -> {
            if (!this.copeService.search.isLoading()) {
                this.refreshList();
            }
        }).method_46434(farLeftXTopRow + 336, buttonTopRowY, 80, 20).method_46431());
        this.protectedButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Protected"), button -> {
            UpdateServerRequest req = new UpdateServerRequest();
            req.isProtected = true;
            this.updateServer(req, this.serverListWidget.removeSelectedServerEntry());
        }).method_46434(farLeftXBottomRow, buttonBottomRowY, 80, 20).method_46431());
        this.whiteListedButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Whitelisted"), button -> {
            UpdateServerRequest req = new UpdateServerRequest();
            req.isWhitelisted = true;
            this.updateServer(req, this.serverListWidget.removeSelectedServerEntry());
        }).method_46434(farLeftXBottomRow + 4 + 80, buttonBottomRowY, 80, 20).method_46431());
        this.buttonModded = class_4185.method_46430((class_2561)class_2561.method_43471((String)"Modded"), button -> {
            UpdateServerRequest req = new UpdateServerRequest();
            req.isModded = true;
            this.updateServer(req, this.serverListWidget.removeSelectedServerEntry());
        }).method_46434(farLeftXBottomRow + 168, buttonBottomRowY, 80, 20).method_46431();
        this.method_37063((class_364)this.buttonModded);
        this.griefedButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"Griefed"), button -> {
            UpdateServerRequest req = new UpdateServerRequest();
            req.isGriefed = true;
            this.updateServer(req, this.serverListWidget.removeSelectedServerEntry());
        }).method_46434(farLeftXBottomRow + 252, buttonBottomRowY, 80, 20).method_46431();
        this.method_37063((class_364)this.griefedButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Cancel"), button -> this.field_22787.method_1507(this.parent)).method_46434(farLeftXBottomRow + 336, buttonBottomRowY, 80, 20).method_46431());
        this.updateButtonActivationStates();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Proxies"), button -> this.field_22787.method_1507((class_437)GuiThemes.get().proxiesScreen())).method_46434(this.field_22789 - 75 - 3, 3, 75, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Accounts"), button -> this.field_22787.method_1507((class_437)GuiThemes.get().accountsScreen())).method_46434(this.field_22789 - 75 - 3 - 75 - 2, 3, 75, 20).method_46431());
    }

    public CopeServerListWidget getServerListWidget() {
        return this.serverListWidget;
    }

    public void method_25393() {
        super.method_25393();
        this.serverListPinger.method_3000();
    }

    public void method_25432() {
        this.serverListPinger.method_3004();
        this.serverListWidget.onRemoved();
    }

    private void refresh() {
        this.field_22787.method_1507((class_437)new class_500(this.parent));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 294) {
            this.refresh();
            return true;
        }
        if (this.serverListWidget.method_25334() != null) {
            if (class_8494.method_51255((int)keyCode)) {
                this.connect();
                return true;
            }
            return this.serverListWidget.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private String getLoadingText() {
        long dotsCount = Instant.now().getEpochSecond() % 5L;
        StringBuilder text = new StringBuilder("Loading");
        int i = 0;
        while ((long)i <= dotsCount) {
            text.append(".");
            ++i;
        }
        return text.toString();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.copeService.search.isLoading() && this.serverListWidget.getServers().isEmpty()) {
            context.method_25300(this.field_22793, this.getLoadingText(), this.field_22789 / 2, 50, 0xFFFFFF);
        }
        this.multiplayerScreenTooltip = null;
        this.serverListWidget.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        if (this.multiplayerScreenTooltip != null) {
            context.method_51434(this.field_22793, this.multiplayerScreenTooltip, mouseX, mouseY);
        }
    }

    public void method_25434(class_332 context) {
        context.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        if (this.mode == Mode.SERVERS) {
            context.method_25293(SERVER_BACKGROUND, 0, 0, this.field_22789, this.field_22790, 0.0f, 0.0f, 16, 128, 16, 128);
        } else {
            context.method_25291(TWITCH_BACKGROUND, 0, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, 32, 32);
        }
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void connect() {
        CopeServerListWidget.Entry entry = (CopeServerListWidget.Entry)this.serverListWidget.method_25334();
        if (entry instanceof CopeServerListWidget.ServerEntry) {
            this.connect(((CopeServerListWidget.ServerEntry)entry).getServer());
        }
    }

    private void connect(class_642 entry) {
        class_412.method_36877((class_437)this, (class_310)this.field_22787, (class_639)class_639.method_2950((String)entry.field_3761), (class_642)entry, (boolean)false);
    }

    public void select(CopeServerListWidget.Entry entry) {
        this.serverListWidget.setSelected(entry);
        this.updateButtonActivationStates();
    }

    protected void updateButtonActivationStates() {
        CopeServerListWidget.Entry entry;
        if (this.buttonJoin != null) {
            this.buttonJoin.field_22763 = false;
        }
        if (this.whiteListedButton != null) {
            this.whiteListedButton.field_22763 = false;
        }
        if (this.protectedButton != null) {
            this.protectedButton.field_22763 = false;
        }
        if (this.buttonModded != null) {
            this.buttonModded.field_22763 = false;
        }
        if (this.griefedButton != null) {
            this.griefedButton.field_22763 = false;
        }
        if ((entry = (CopeServerListWidget.Entry)this.serverListWidget.method_25334()) != null) {
            this.buttonJoin.field_22763 = true;
            if (entry instanceof CopeServerListWidget.ServerEntry) {
                if (this.whiteListedButton != null) {
                    this.whiteListedButton.field_22763 = true;
                }
                if (this.protectedButton != null) {
                    this.protectedButton.field_22763 = true;
                }
                if (this.buttonModded != null) {
                    this.buttonModded.field_22763 = true;
                }
                if (this.griefedButton != null) {
                    this.griefedButton.field_22763 = true;
                }
            }
        }
    }

    public class_644 getServerListPinger() {
        return this.serverListPinger;
    }

    public void setMultiplayerScreenTooltip(List<class_2561> tooltip) {
        this.multiplayerScreenTooltip = tooltip;
    }

    public ServerList getServerList() {
        return this.serverList;
    }

    public void refreshList() {
        CopeServerListWidget serverListWidget = this.serverListWidget;
        this.serverListPinger.method_3004();
        if (serverListWidget != null) {
            serverListWidget.setServers(new ServerList(this.serverListPinger));
            switch (this.mode) {
                case SERVERS: {
                    this.copeService.search.currentFindRequest.skip = 0;
                    this.copeService.search.find(this::setCopeServers);
                    break;
                }
                case STREAMERS: {
                    this.copeService.search.findStreamers(this::setCopeStreamers);
                }
            }
        }
    }

    public void showMore() {
        CopeServerListWidget serverListWidget = this.serverListWidget;
        if (serverListWidget != null) {
            this.copeService.search.findMore(this::addCopeServers);
        }
    }

    private void updateServer(UpdateServerRequest req, Optional<CopeServerListWidget.Entry> entryOptional) {
        entryOptional.ifPresent(entry -> ForkJoinPool.commonPool().submit(() -> {
            CopeServerListWidget.ServerEntry serverEntry = (CopeServerListWidget.ServerEntry)entry;
            req.server = serverEntry.getServer().field_3761;
            this.copeService.update(req, server -> {});
        }));
    }

    private void setCopeServers(List<Server> servers, List<Server> activeServers) {
        this.serverList = new ServerList(this.serverListPinger);
        this.mapServers(servers, activeServers);
        this.serverListWidget.setSelected(null);
        this.serverListWidget.setServers(this.serverList);
    }

    private void setCopeStreamers(List<Streamer> streamers) {
        this.serverList = new ServerList(this.serverListPinger);
        this.addStreamers(streamers);
        this.serverListWidget.setSelected(null);
        this.serverListWidget.setServers(this.serverList);
    }

    private void addCopeServers(List<Server> servers, List<Server> activeServers) {
        this.mapServers(servers, activeServers);
    }

    private void mapServers(List<Server> servers, List<Server> activeServers) {
        this.addServers(activeServers, server -> {
            if (server.griefers != null && !server.griefers.isEmpty()) {
                StringJoiner joiner = new StringJoiner(",");
                server.griefers.stream().map(griefer -> StreamerMode.isStreaming() ? griefer.playerNameAlias : griefer.profileName).forEach(joiner::add);
                return server.displayServerAddress() + " with " + joiner;
            }
            return server.displayServerAddress();
        });
        this.addServers(servers, Server::displayServerAddress);
    }

    private void addServers(List<Server> servers, Function<Server, String> name) {
        class_310.method_1551().execute(() -> {
            servers.stream().map(found -> new CopeServerInfo((String)name.apply((Server)found), (Server)found, null)).forEach(serverInfo -> this.serverList.add((class_642)serverInfo));
            this.serverListWidget.setServers(this.serverList);
        });
    }

    private void addStreamers(List<Streamer> streamers) {
        class_310.method_1551().execute(() -> {
            streamers.stream().map(found -> {
                Server server = new Server();
                server.serverAddress = found.server().ip() + ":" + found.server().port();
                return new CopeServerInfo(found.stream().displayURL(), server, (Streamer)found);
            }).forEach(serverInfo -> this.serverList.add((class_642)serverInfo));
            this.serverListWidget.setServers(this.serverList);
        });
    }

    public static enum Mode {
        SERVERS,
        STREAMERS;

    }
}

