/*
 * Decompiled with CFR 0.152.
 */
package fifthcolumn.n.client.reflection;

import java.lang.reflect.Field;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class FabricReflect {
    public static Field getField(Class<?> cls, String obfName, String deobfName) {
        if (cls == null) {
            return null;
        }
        for (Class<?> cls1 = cls; cls1 != null; cls1 = cls1.getSuperclass()) {
            Field field;
            try {
                field = cls1.getDeclaredField(obfName);
            }
            catch (Exception e) {
                try {
                    field = cls1.getDeclaredField(deobfName);
                }
                catch (Exception e1) {
                    continue;
                }
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }
        for (Class class1 : ClassUtils.getAllInterfaces(cls)) {
            Field field;
            try {
                field = class1.getField(obfName);
            }
            catch (Exception e) {
                try {
                    field = class1.getField(deobfName);
                }
                catch (Exception e1) {
                    continue;
                }
            }
            return field;
        }
        throw new RuntimeException("Error reflecting field: " + deobfName + "/" + obfName + " @" + cls.getSimpleName());
    }

    public static Object getFieldValue(Object target, String obfName, String deobfName) {
        Class<?> cls;
        if (target == null) {
            return null;
        }
        for (Class<?> cls1 = cls = target.getClass(); cls1 != null; cls1 = cls1.getSuperclass()) {
            Field field;
            try {
                field = cls1.getDeclaredField(obfName);
            }
            catch (Exception e) {
                try {
                    field = cls1.getDeclaredField(deobfName);
                }
                catch (Exception e1) {
                    continue;
                }
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                return field.get(target);
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting reflected field value: " + deobfName + "/" + obfName + " @" + target.getClass().getSimpleName());
            }
        }
        for (Class class1 : ClassUtils.getAllInterfaces(cls)) {
            Field field;
            try {
                field = class1.getField(obfName);
            }
            catch (Exception e) {
                try {
                    field = class1.getField(deobfName);
                }
                catch (Exception e1) {
                    continue;
                }
            }
            try {
                return field.get(target);
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting reflected field value: " + deobfName + "/" + obfName + " @" + target.getClass().getSimpleName());
            }
        }
        throw new RuntimeException("Error getting reflected field value: " + deobfName + "/" + obfName + " @" + target.getClass().getSimpleName());
    }

    public static void writeField(Object target, Object value, String obfName, String deobfName) {
        if (target == null) {
            return;
        }
        Class<?> cls = target.getClass();
        Field field = FabricReflect.getField(cls, obfName, deobfName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing reflected field: " + deobfName + "/" + obfName + " @" + target.getClass().getSimpleName());
        }
    }

    public static Object invokeMethod(Object target, String obfName, String deobfName, Object ... args) {
        Object o;
        try {
            o = MethodUtils.invokeMethod((Object)target, (boolean)true, (String)obfName, (Object[])args);
        }
        catch (Exception e) {
            try {
                o = MethodUtils.invokeMethod((Object)target, (boolean)true, (String)deobfName, (Object[])args);
            }
            catch (Exception e1) {
                throw new RuntimeException("Error reflecting method: " + deobfName + "/" + obfName + " @" + target.getClass().getSimpleName());
            }
        }
        return o;
    }
}

